function Pedestrian(n, sx, sy, sp, active) {
	this.name = n;
	this.sx = sx;
	this.sy = sy;
	this.bitmap = null;
	this.speed = typeof sp !== 'undefined' ? sp : 4;
	this.active = typeof active !== 'undefined' ? active : false;
}

Pedestrian.prototype.init = function(image) {
	var img = image;
	if (img != null) {
		var sprite = new createjs.SpriteSheet({
			images: [img],
			framerate: 10,
			frames: {
				width: this.sx,
				height: this.sy
			},
			animations: {
				right: [0, 27],
				back: [28, 55],
				front: [56, 83],
				left: [84, 111]
			}
		});

		this.bitmap = new createjs.BitmapAnimation(sprite);
	}
}
